<section class="shortcode-branch-locations box-section background-body pt-110">
    <div class="container">
        @if ($title = $shortcode->title)
            <div class="text-start">
                <h4 class="shortcode-title">{!! BaseHelper::clean($title) !!}</h4>
            </div>
        @endif

        <div class="row mt-30">
            @foreach($tabs as $item)
                @continue(! ($title = Arr::get($item, 'name')))
                <div class="col-lg-3 col-sm-6">
                    <div class="card-contact">
                        @if ($image = Arr::get($item, 'icon_image'))
                            <div class="card-image">
                                <div class="card-icon">
                                    {{ RvMedia::image($image, 'icon', attributes: ['width' => 32, 'height' => 32]) }}
                                </div>
                            </div>
                        @endif

                        <div class="card-info">
                            <div class="card-title mb-">
                                <a class="title heading-6" href="#">{!! BaseHelper::clean($title) !!}</a>
                            </div>
                            <div class="card-method-contact">
                                @if ($address = Arr::get($item, 'address'))
                                    <div class="d-flex align-items-start mb-2">
                                        <div class="icon">
                                            <svg class="invert" xmlns="http://www.w3.org/2000/svg" width="18" height="19" viewBox="0 0 18 19" fill="none">
                                                <path d="M9 1.0625C7.35897 1.0625 5.78516 1.7144 4.62478 2.87478C3.4644 4.03516 2.8125 5.60897 2.8125 7.25C2.8125 10.5181 8.325 17.4312 8.56125 17.7294C8.61396 17.7951 8.68074 17.8481 8.75668 17.8845C8.83262 17.921 8.91577 17.9399 9 17.9399C9.08423 17.9399 9.16738 17.921 9.24332 17.8845C9.31925 17.8481 9.38604 17.7951 9.43875 17.7294C9.675 17.4312 15.1875 10.5181 15.1875 7.25C15.1875 5.60897 14.5356 4.03516 13.3752 2.87478C12.2148 1.7144 10.641 1.0625 9 1.0625ZM9 16.4637C7.26188 14.2137 3.9375 9.4325 3.9375 7.25C3.9375 5.90734 4.47087 4.61967 5.42027 3.67027C6.36967 2.72087 7.65734 2.1875 9 2.1875C10.3427 2.1875 11.6303 2.72087 12.5797 3.67027C13.5291 4.61967 14.0625 5.90734 14.0625 7.25C14.0625 9.4325 10.7381 14.2025 9 16.4637Z" fill="#101010" />
                                                <path d="M9 3.3125C8.33249 3.3125 7.67997 3.51044 7.12495 3.88129C6.56994 4.25214 6.13735 4.77924 5.88191 5.39594C5.62646 6.01264 5.55963 6.69124 5.68985 7.34593C5.82008 8.00062 6.14151 8.60198 6.61352 9.07399C7.08552 9.54599 7.68689 9.86743 8.34157 9.99765C8.99626 10.1279 9.67486 10.061 10.2916 9.80559C10.9083 9.55015 11.4354 9.11757 11.8062 8.56255C12.1771 8.00753 12.375 7.35501 12.375 6.6875C12.375 5.79239 12.0194 4.93395 11.3865 4.30101C10.7536 3.66808 9.89511 3.3125 9 3.3125ZM9 8.9375C8.55499 8.9375 8.11998 8.80554 7.74997 8.55831C7.37996 8.31107 7.09157 7.95967 6.92127 7.54854C6.75098 7.1374 6.70642 6.685 6.79323 6.24855C6.88005 5.81209 7.09434 5.41118 7.40901 5.09651C7.72368 4.78184 8.12459 4.56755 8.56105 4.48073C8.99751 4.39392 9.4499 4.43847 9.86104 4.60877C10.2722 4.77907 10.6236 5.06746 10.8708 5.43747C11.118 5.80748 11.25 6.24249 11.25 6.6875C11.25 7.28424 11.0129 7.85653 10.591 8.27849C10.169 8.70045 9.59674 8.9375 9 8.9375Z" fill="#101010" />
                                            </svg>

                                        </div>
                                        <a class="location text-md-medium ms-2" href="https://maps.google.com/?q={{ $address }}">{!! BaseHelper::clean($address) !!}</a>
                                    </div>
                                @endif

                                @if ($phone = Arr::get($item, 'phone'))
                                    <div class="d-flex align-items-start mb-2">
                                        <div class="icon">
                                            <svg class="invert" xmlns="http://www.w3.org/2000/svg" width="20" height="21" viewBox="0 0 20 21" fill="none">
                                                <path d="M3.92512 7.77453C5.22103 11.9687 8.53091 15.2786 12.7251 16.5745C14.8357 17.2266 16.6663 15.3757 16.6663 13.1666C16.6663 12.6143 16.2171 12.1729 15.6687 12.1075C14.9545 12.0223 14.268 11.8467 13.621 11.5926L12.355 12.8587C10.2958 11.8732 8.62635 10.2038 7.64091 8.14464L8.90698 6.87857C8.65286 6.23159 8.47732 5.54513 8.39211 4.83093C8.32669 4.28253 7.88529 3.83325 7.33301 3.83325C5.12387 3.83325 3.27296 5.66384 3.92512 7.77453Z" stroke="#101010" stroke-linecap="round" stroke-linejoin="round" />
                                            </svg>
                                        </div>
                                        <a class="phone text-md-medium ms-2" dir="ltr" href="tel:{{ $phone }}" dir="ltr">{!! BaseHelper::clean($phone) !!}</a>
                                    </div>
                                @endif

                                @if($email = Arr::get($item, 'email'))
                                    <div class="d-flex align-items-center">
                                        <div class="icon">
                                            <svg class="invert" xmlns="http://www.w3.org/2000/svg" width="16" height="13" viewBox="0 0 16 13" fill="none">
                                                <path d="M14.5938 0.875H1.40625C0.629281 0.875 0 1.50819 0 2.28125V10.7188C0 11.4964 0.633906 12.125 1.40625 12.125H14.5938C15.3642 12.125 16 11.4991 16 10.7188V2.28125C16 1.50956 15.3732 0.875 14.5938 0.875ZM14.3968 1.8125C14.1095 2.09828 9.16509 7.01666 8.99438 7.18647C8.72875 7.45209 8.37563 7.59834 8 7.59834C7.62437 7.59834 7.27125 7.45206 7.00475 7.18559C6.88994 7.07137 2.00009 2.20731 1.60319 1.8125H14.3968ZM0.9375 10.5279V2.47266L4.98869 6.5025L0.9375 10.5279ZM1.60378 11.1875L5.65338 7.16366L6.34272 7.84937C6.78541 8.29206 7.37397 8.53584 8 8.53584C8.62603 8.53584 9.21459 8.29206 9.65641 7.85025L10.3466 7.16366L14.3962 11.1875H1.60378ZM15.0625 10.5279L11.0113 6.5025L15.0625 2.47266V10.5279Z" fill="#101010" />
                                            </svg>
                                        </div>
                                        <a class="email text-md-medium ms-2" href="mailto:{{ $email }}">{!! BaseHelper::clean($email) !!}</a>
                                    </div>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>
    </div>
</section>
